<?php
date_default_timezone_set('Asia/Kolkata');
$mysqli = new mysqli("localhost", "dashboard", "Dashboard@2025", "mtm_dashboard");
if ($mysqli->connect_error) {
    die("Connection failed: " . $mysqli->connect_error);
}

$query = "
    SELECT 
        m.user_id,
        m.alias,
        m.margin,
        COALESCE(s.current_mtm, 0) AS current_mtm,
        COALESCE(s.max_mtm, 0) AS max_mtm,
        COALESCE(s.min_mtm, 0) AS min_mtm,
        COALESCE(s.available_margin, 0) AS available_margin
    FROM mtm_users m
    LEFT JOIN user_stats s ON m.user_id = s.user_id
    ORDER BY m.alias
";

$result = $mysqli->query($query);
$data = [];
while ($row = $result->fetch_assoc()) {
    $margin = floatval($row['margin']);
    $available = floatval($row['available_margin']);
    $used_margin_percent = ($margin > 0) ? round((($margin - $available) / $margin) * 100, 2) : 0;
    $row['used_margin_percent'] = $used_margin_percent;
    $data[] = $row;
}
$mysqli->close();
header('Content-Type: application/json');
echo json_encode($data);
?>
